/* ============ */
/* planpokr.c	*/
/* ============ */
#include <defcodes.h>
#include <miscdefs.h>
#include "pokrprob.c"

#define	DEFAULT_CELL_COUNT	 5
#define	DEFAULT_DATA_WIDTH	10
#define	DEFAULT_HAND_SIZE	 5

#define	HI_POW	15
#define	LO_POW	 4
#define	ACT(X)	#X
#define	NEED_POW(L,U)	\
    "Enter power of 2 for largest integer [>= " ACT(L) ", <= " ACT(U) "]: "
/* ==================================================================== */
/* PlanPoker - Main program to plan a poker-test run			*/
/* ==================================================================== */
void
main()
{
    /* ------------------------------------------------ */
    /* This program will request the following data:	*/
    /*                                                  */
    /*	1. Number of cards per hand to be examined.     */
    /*	2. Data Width of numbers to be generated.       */
    /*     In this application, data width is a         */
    /*	   number that represents the length of         */
    /*     the random-number cycle.  Suggested          */
    /*	   values:                                      */
    /*                                                  */
    /*		5, 10, 16, 32                           */
    /*                                                  */
    /*	   For my own part, I have clamped the entry    */
    /*	   to the limits (5, 128).                      */
    /*                                                  */
    /*	2. Minimum Cell Expectation in Each Category	*/
    /*                                                  */
    /*	   This is typically 5 or 10, preferably 10,	*/
    /*	   but certainly no less than 5 or you'll git	*/
    /*	   et by the hogs.
    /* ------------------------------------------------ */

    AbortGracefully();			/* Causes ^C to Behave */

    while (main)
    {
	int	HandSize = 0;
	int	CellExpect = 0, i, DataWidth = 0;
	double	PokerProbVals[64], ProbTotal;

	GetInt("Enter Number of Cards Per Hand: ", &HandSize);
	GetInt("Enter Data Width (e.g. 10, 16, 32, ...): ", &DataWidth);

	GetInt("Enter Minimum Cell Expectation in Each Category: ",
		&CellExpect);

	if (HandSize > 0)
	{
	    printf("HandSize = %d\n", HandSize);
	}
	else
	{
	    HandSize = DEFAULT_HAND_SIZE;
	    printf("HandSize is set to %d by default\n", HandSize);
	}
	if (DataWidth < HandSize)
	{
	    DataWidth = HandSize;
	    printf("DataWidth Must Be >= HandSize ... Setting ");
	}
	if (DataWidth > 0)
	{
	    printf("DataWidth = %d\n", DataWidth);
	}
	else
	{
	    DataWidth = DEFAULT_DATA_WIDTH;
	    printf("DataWidth is set to %d by default\n", DataWidth);
	}
	if (CellExpect > 0)
	{
	    printf("Minimum Cell Expectation = %d\n", CellExpect);
	}
	else
	{
	    CellExpect = DEFAULT_CELL_COUNT;
	    printf("Minimum Cell Expectation is set to %d by default\n",
		CellExpect);
	}

	CalcPokerProbs(HandSize, DataWidth, PokerProbVals);
	printf("\nPoker Probabilities:\n  r      Pr%15s", "");
	printf("Cell Expectation     # Variates Required\n");
	ProbTotal = 0;
	for (i = HandSize; i >= 1; --i)
	{
	    double  DevReqd = floor(0.5 + CellExpect/PokerProbVals[i - 1]);

	    ProbTotal += PokerProbVals[i - 1];

	    printf("%3d  %.11e%10s", i, PokerProbVals[i - 1], "");
	    printf("%2d%15s%.f\n", CellExpect, "", DevReqd);
	}
	printf("     %.11e  (Total)\n", ProbTotal);
    }
}
